#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Year of Truchets #017Mod01.fsh   by   byt3_m3chanic   
//https://www.shadertoy.com/view/mld3Wj
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/** 

    License: Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License
    
    Year of Truchets #017
    05/05/2023  @byt3_m3chanic
    
    - music just for effect -
    
    All year long I'm going to just focus on truchet tiles and the likes!
    Truchet Core \M/->.<-\M/ 2023 
    
*/

#define R           iResolution
#define T           iTime
#define M           iMouse

#define PI         3.14159265359
#define PI2        6.28318530718

float hash21(vec2 a) { return fract(sin(dot(a, vec2(27.609, 57.583)))*43758.5453);}
mat2 rot(float a) { return mat2(cos(a),sin(a),-sin(a),cos(a));}
//@iq hue palettes 
vec3 hue(float t){ return .35 + .4*cos(PI2*t*(vec3(.95,.97,.98)*vec3(0.098,0.345,0.843))); }

float ck = 0., d2 = 0.;
vec2 g = vec2(0), id = vec2(0);

float makeTile(vec2 uv){

    id = floor(uv);
    vec2 q = fract(uv)-.5;
    g = q;
  
    ck = mod(id.x+id.y,2.)*2.-1.;
    float hs = hash21(id);

    float wd = .12+.1*sin(uv.x*.75+T*2.5);
    if(hs>.5) q *= rot(1.5707);
    
    vec2 sp = vec2(length(q-.5),length(q+.5));
    vec2 p = sp.x<sp.y? q-.5 : q+.5;

    // main pattern
    float d = length(p)-.5;
    d = abs(d)-wd;
    
    float c = min(length(q.x)-wd,length(q.y)-wd);
    if (hs>.9) d = c;
    
    hs = fract(hs*413.372);
    if (hs>.9) d = min(length(abs(q)-vec2(.5,0))-wd,length(q.x)-wd);
    if (hs<.1) d = min(abs(length(q)-.2)-wd,max(c,-(length(q)-.2)));

    d2 = abs(max(abs(q.x),abs(q.y))-.5)-.005;

    return d;
}
#define O fragColor
#define F fragCoord
//void mainImage( out vec4 O, in vec2 F ) {
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec3 C = vec3(.01);
    
    vec2 uv = (2.*F-R.xy)/max(R.x,R.y);
    vec2 vv = uv;
   
    float fd = (uv.y+.25)*1.35;
    fd = clamp(1.,0.,fd);

    
    uv *= rot(-T*.11);
    uv = vec2(log(length(uv)), atan(uv.y, uv.x))*5.41;  //3.5;//2.545;//1.91;//1.2726;//.63;
    uv.x -= T*.35;
        
    vec3 clr = hue((uv.x+2.)*.209);
    vec3 clx = hue((uv.x+2.)*.41);

    float px = fwidth(uv.x); 
    float d = makeTile(uv);

    float s = smoothstep(.075+px,-px,d);
    d2 = smoothstep(px,-px,d2);

    C = mix(C,vec3(.125),d2);
    C = mix(C,C*.3,s);
    
    float d3 = smoothstep(px,-px,abs(d)-.04);
    float d4=mix(d,0.,fd);
    
    d4 = smoothstep(px,-px,d4+.1);
    d = smoothstep(px,-px,d);
    
    C = mix(C,clr,d);
    C = mix(C,C*.1,d3);
    C = mix(C,clamp(C+.3,C,vec3(1)),d4);
    
    float v = length(vv)-.0005;
    v = smoothstep(.2,.0,v);
    C = mix(C,vec3(.01),clamp(0.,.7,v));
    C = pow(C,vec3(.4545));
    fragColor = vec4(C,1.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

